// DOM.event.move
//
// 2.0.0
//
// Stephen Band
//
// Triggers 'movestart', 'move' and 'moveend' events after
// mousemoves following a mousedown cross a distance threshold,
// similar to the native 'dragstart', 'drag' and 'dragend' events.
// Move events are throttled to animation frames. Move event objects
// have the properties:
//
// pageX:
// pageY:     Page coordinates of pointer.
// startX:
// startY:    Page coordinates of pointer at movestart.
// distX:
// distY:     Distance the pointer has moved since movestart.
// deltaX:
// deltaY:    Distance the finger has moved since last event.
// velocityX:
// velocityY: Average velocity over last few events.

!function(e){"function"==typeof define&&define.amd?define([],e):"undefined"!=typeof module&&null!==module&&module.exports?module.exports=e:e()}(function(){var o=Object.assign||window.jQuery&&jQuery.extend,r=8,a=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e,t){return window.setTimeout(function(){e()},25)};function e(e,t){t=t||{bubbles:!1,cancelable:!1,detail:void 0};var n=document.createEvent("CustomEvent");return n.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),n}"function"!=typeof window.CustomEvent&&(e.prototype=window.Event.prototype,window.CustomEvent=e);var i,n={textarea:!0,input:!0,select:!0,button:!0},c={move:"mousemove",cancel:"mouseup dragstart",end:"mouseup"},u={move:"touchmove",cancel:"touchend",end:"touchend"},d=/\s+/,m={bubbles:!0,cancelable:!0},t="function"==typeof Symbol?Symbol("events"):{};function v(e){return e[t]||(e[t]={})}function s(e,t,n,o){t=t.split(d);var i,a=v(e),c=t.length;function u(e){n(e,o)}for(;c--;)(a[i=t[c]]||(a[i]=[])).push([n,u]),e.addEventListener(i,u)}function f(e,t,n){t=t.split(d);var o,i,a,c=v(e),u=t.length;if(c)for(;u--;)if(i=c[o=t[u]])for(a=i.length;a--;)i[a][0]===n&&(e.removeEventListener(o,i[a][1]),i.splice(a,1))}function l(e,t,n){t=new CustomEvent(t,m);n&&o(t,n),e.dispatchEvent(t)}function p(e){var n=e,o=!1,i=!1;function t(e){o?(n(),a(t),o=!(i=!0)):i=!1}this.kick=function(e){o=!0,i||t()},this.end=function(e){var t=n;e&&(i?(n=o?function(){t(),e()}:e,o=!0):e())}}function g(){}function h(e){e.preventDefault()}function X(e,t){var n,o;if(e.identifiedTouch)return e.identifiedTouch(t);for(n=-1,o=e.length;++n<o;)if(e[n].identifier===t)return e[n]}function Y(e,t){e=X(e.changedTouches,t.identifier);if(e&&(e.pageX!==t.pageX||e.pageY!==t.pageY))return e}function y(e,t){E(e,t,e,b)}function w(e,t){b()}function b(){f(document,c.move,y),f(document,c.cancel,w)}function T(e){f(document,u.move,e.touchmove),f(document,u.cancel,e.touchend)}function E(e,t,n,o){var i,a,c=n.pageX-t.pageX,u=n.pageY-t.pageY;c*c+u*u<r*r||(a=t,t=n,n=c,c=u,u=o,o=(i=e).targetTouches,e=i.timeStamp-a.timeStamp,o={altKey:i.altKey,ctrlKey:i.ctrlKey,shiftKey:i.shiftKey,startX:a.pageX,startY:a.pageY,distX:n,distY:c,deltaX:n,deltaY:c,pageX:t.pageX,pageY:t.pageY,velocityX:n/e,velocityY:c/e,identifier:a.identifier,targetTouches:o,finger:o?o.length:1,enableMove:function(){this.moveEnabled=!0,this.enableMove=g,i.preventDefault()}},l(a.target,"movestart",o),u(a))}function S(e,t){var n=t.timer;t.touch=e,t.timeStamp=e.timeStamp,n.kick()}function k(e,t){var n=t.target,o=t.event,t=t.timer;f(document,c.move,S),f(document,c.end,k),j(n,o,t,function(){setTimeout(function(){f(n,"click",h)},0)})}function K(e,t){var n=t.target,o=t.event,i=t.timer;X(e.changedTouches,o.identifier)&&(t=t,f(document,u.move,t.activeTouchmove),f(document,u.end,t.activeTouchend),j(n,o,i))}function j(e,t,n,o){n.end(function(){return l(e,"moveend",t),o&&o()})}function C(e){e.enableMove()}function Q(e){e.enableMove()}function q(e){e.enableMove()}function A(e){var o=e.handler;e.handler=function(e){for(var t,n=i.length;n--;)e[t=i[n]]=e.originalEvent[t];o.apply(this,arguments)}}s(document,"mousedown",function(e){var t;1!==(t=e).which||t.ctrlKey||t.altKey||n[e.target.tagName.toLowerCase()]||(s(document,c.move,y,e),s(document,c.cancel,w,e))}),s(document,"touchstart",function(e){n[e.target.tagName.toLowerCase()]||(e={target:(e=e.changedTouches[0]).target,pageX:e.pageX,pageY:e.pageY,identifier:e.identifier,touchmove:function(e,t){var n;(t=Y(n=e,e=t))&&E(n,e,t,T)},touchend:function(e,t){t=t,X(e.changedTouches,t.identifier)&&T(t)}},s(document,u.move,e.touchmove,e),s(document,u.cancel,e.touchend,e))}),s(document,"movestart",function(e){var t,n;e.defaultPrevented||e.moveEnabled&&(t={startX:e.startX,startY:e.startY,pageX:e.pageX,pageY:e.pageY,distX:e.distX,distY:e.distY,deltaX:e.deltaX,deltaY:e.deltaY,velocityX:e.velocityX,velocityY:e.velocityY,identifier:e.identifier,targetTouches:e.targetTouches,finger:e.finger},n={target:e.target,event:t,timer:new p(function(e){(function(e,t,n){n-=e.timeStamp,e.distX=t.pageX-e.startX,e.distY=t.pageY-e.startY,e.deltaX=t.pageX-e.pageX,e.deltaY=t.pageY-e.pageY,e.velocityX=.3*e.velocityX+.7*e.deltaX/n,e.velocityY=.3*e.velocityY+.7*e.deltaY/n,e.pageX=t.pageX,e.pageY=t.pageY})(t,n.touch,n.timeStamp),l(n.target,"move",t)}),touch:void 0,timeStamp:e.timeStamp},void 0===e.identifier?(s(e.target,"click",h),s(document,c.move,S,n),s(document,c.end,k,n)):(n.activeTouchmove=function(e,t){var n,o,i;n=e,i=(o=t).event,e=o.timer,(t=Y(n,i))&&(n.preventDefault(),i.targetTouches=n.targetTouches,o.touch=t,o.timeStamp=n.timeStamp,e.kick())},n.activeTouchend=function(e,t){K(e,t)},s(document,u.move,n.activeTouchmove,n),s(document,u.end,n.activeTouchend,n)))}),window.jQuery&&(i="startX startY pageX pageY distX distY deltaX deltaY velocityX velocityY".split(" "),jQuery.event.special.movestart={setup:function(){return s(this,"movestart",C),!1},teardown:function(){return f(this,"movestart",C),!1},add:A},jQuery.event.special.move={setup:function(){return s(this,"movestart",Q),!1},teardown:function(){return f(this,"movestart",Q),!1},add:A},jQuery.event.special.moveend={setup:function(){return s(this,"movestart",q),!1},teardown:function(){return f(this,"movestart",q),!1},add:A})});